/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import java.util.Vector; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class AttachmentAgent extends AgentBase {

	private static final String PATH = "C:\\temp\\";

	public void NotesMain() {
		Document doc = null; RichTextNavigator rtn = null;
		Database db = null; EmbeddedObject eo = null;
		RichTextItem rt = null, hiddenRT = null; 
		try {
		//Vorbereitung
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();
			String base = System.getProperty("java.home");
			base = base.substring(0,base.length()-4);
			db = agentContext.getCurrentDatabase(); doc = agentContext.getDocumentContext();
		//Neues Dokument erstellen oder Context Document laden...
			if (doc != null && !(doc.getItemValueString("F_Titel"))
				.equals("Demo Dokument mit Attachment")) {
				doc = db.createDocument ();}
			doc.replaceItemValue("Form", "FO_dokument_k2");
			doc.replaceItemValue("F_Titel", "Demo Dokument mit Attachment" );
		//RichText Feld 1 -> nicht sichtbar in der Maske
			rt = (RichTextItem) doc.getFirstItem ("F_attachment");
			if (rt == null) {
				rt = doc.createRichTextItem("F_attachment");}
			rt.embedObject(EmbeddedObject.EMBED_ATTACHMENT, "", base
					+ "\\data\\image.gif", "demoGif");			
		//RichText Feld 2 -> sichtbar in der Maske
			rt = (RichTextItem) doc.getFirstItem("F_richText");
			if (rt == null) {
				rt = doc.createRichTextItem("F_richText");}
			rt.embedObject(EmbeddedObject.EMBED_ATTACHMENT, "", base
					+ "\\data\\binary.gif", "demoGifVisible");
		//Auswertung ...
			rt.appendText("Vor dem Speichern: "+rt.getEmbeddedObjects().size() + "/" + doc.getEmbeddedObjects().size());
			rt.addNewLine();
			doc.save(true, false);
			rt.appendText("Nach dem Speichern: "+rt.getEmbeddedObjects().size() + "/" + doc.hasEmbedded());
			rt.addNewLine();
		//Bsp 1: Anhang via RichTextNavigator ablsen und speichern...
			rtn = rt.createNavigator();
			eo = (EmbeddedObject) rtn
					.getLastElement(RichTextItem.RTELEM_TYPE_FILEATTACHMENT);
			eo.extractFile(PATH + eo.getName());
			rt.appendText("Datei erfolgreich nach " + PATH + eo.getName()
					+ " abgelst."); rt.addNewLine();
			eo.recycle();
		//Bsp 2: Anhang aus RichText Item extrahieren und speichern...
			hiddenRT = (RichTextItem) doc.getFirstItem("F_attachment");
			Vector v = hiddenRT.getEmbeddedObjects();
			eo = (EmbeddedObject) v.elementAt(v.size()-1); //letzter Eintrag
			String attachFileName = eo.getSource();
			String attachName = eo.getName();
			eo.extractFile(PATH + attachFileName);
			rt.appendText("Datei erfolgreich nach " + PATH + attachFileName
					+ " (interner Name: " + attachName + ")" + " abgelst.");
			rt.addNewLine(); eo.recycle();
		//Bsp 3: Anhand des Namens aus Document extrahieren und speichern...
			eo = doc.getAttachment (attachName);
			eo.extractFile(PATH + "_erneut_" + attachName);
			rt.appendText("Datei erneut erfolgreich nach " + PATH + "_erneut_" 
					+ attachName + " abgelst."); rt.addNewLine();
		//Bsp 4: Alle Namen aller Anhnge berechnen...
			v = session.evaluate("@attachmentNames", doc);
			rt.appendText("Alle Anhnge: " + v.toString()); rt.addNewLine();			
			doc.save (true,false);
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rt != null) {rt.recycle();}
				if (rtn != null) {rtn.recycle();}
				if (hiddenRT != null) {hiddenRT.recycle();}
				if (eo != null) {eo.recycle();}
				if (doc != null) {doc.recycle();}
				if (db != null) {db.recycle();}
			} catch (NotesException e1) {
				e1.printStackTrace();
			}
		}
	}
}
